
function controlsSetup()
{
	bufferTime = 5;
	
	jumpKeyBuffered = 0;
	jumpKeyBufferTimer = 0;
	
}

function getControls()
{
	//Direkcijas ievade
	rightkey = keyboard_check( vk_right ) + keyboard_check( ord("D"));
		rightkey = clamp ( rightkey, 0, 1)
	
	leftkey = keyboard_check( vk_left ) + keyboard_check (ord("A"));
		leftkey = clamp ( leftkey, 0, 1)
	
	//Darbības ievade
	jumpKeyPressed = keyboard_check_pressed( vk_space );
	
	jumpKey = keyboard_check( vk_space );
	
	if jumpKeyPressed
	{
		jumpKeyBufferTimer = bufferTime;
	}
	if jumpKeyBufferTimer > 0
	{
		jumpKeyBuffered = 1;
		jumpKeyBufferTimer--;
	} else {
		jumpKeyBuffered = 0;
	}
}

function save_game() {
    var save_file = "save_game.ini";
    ini_open(save_file);

    // Save player position
    ini_write_real("Player", "x", oPlayer.x);
    ini_write_real("Player", "y", oPlayer.y);

    // Save player name
    ini_write_string("Player", "name", global.player_name);

    // Save elapsed time
    ini_write_real("Player", "elapsed_time", global.elapsed_time);

    // Save power-ups
    for (var i = 0; i < array_length(global.powerUps); i++) {
        ini_write_real("PowerUps", "powerUp" + string(i), global.powerUps[i]);
    }

    // Save collected orbs
    for (var i = 0; i < ds_list_size(global.collected_orbs); i++) {
        ini_write_real("Orbs", "orb" + string(i), ds_list_find_value(global.collected_orbs, i));
    }

    ini_close();
    show_message("Game Saved Successfully!");
}

function save_player_to_firebase(x, y, name, elapsed_time) {
    var url = "https://jumpster-e74e1-default-rtdb.europe-west1.firebasedatabase.app/player.json"; // Correct Firebase URL
    var data = ds_map_create();
    ds_map_add(data, "x", x);
    ds_map_add(data, "y", y);
    ds_map_add(data, "name", name);
    ds_map_add(data, "elapsed_time", elapsed_time);

    var json_data = json_encode(data);
    ds_map_destroy(data);

    // Set headers for JSON data
    var headers = ds_map_create();
    ds_map_add(headers, "Content-Type", "application/json");

    // Send data to Firebase using PUT method
    var response = http_request(url, "PUT", headers, json_data); // Required 4 arguments: URL, method, headers, and body

    // Log response for debugging
    show_debug_message("Firebase Response: " + string(response));

    ds_map_destroy(headers); // Clean up header map
    show_message("Player data saved successfully!");
}


function save_leaderboard() {
    var leaderboard_file = "leaderboard.ini";
    ini_open(leaderboard_file);

    // Save leaderboard
    for (var i = 0; i < ds_list_size(global.leaderboard); i++) {
        var entry = ds_list_find_value(global.leaderboard, i);
        ini_write_string("Leaderboard", "Entry" + string(i) + "_Name", entry[0]);
        ini_write_real("Leaderboard", "Entry" + string(i) + "_Time", entry[1]);
    }
    ini_close();
}

function save_leaderboard_to_firebase() {
    var url = "https://jumpster-e74e1-default-rtdb.europe-west1.firebasedatabase.app/leaderboard.json"; // Replace with your Firebase URL
    
    // Create a map to hold the leaderboard data
    var leaderboard_map = ds_map_create();
    
    // Loop through the leaderboard and convert each entry into a map with name and time
    for (var i = 0; i < ds_list_size(global.leaderboard); i++) {
        var entry = ds_list_find_value(global.leaderboard, i);
        var player_name = entry[0];
        var elapsed_time = entry[1];
        
        // Add the player data to the map, using the index as the key
        var player_data = ds_map_create();
        player_data[? "name"] = player_name;
        player_data[? "time"] = elapsed_time;
        
        leaderboard_map[? string(i)] = player_data; // Save each player data as a new entry in the map
    }
    
    // Convert the leaderboard map to JSON format
    var json_data = json_encode(leaderboard_map);
    
    // Clean up the leaderboard map
    ds_map_destroy(leaderboard_map);

    // Set headers for JSON data
    var headers = ds_map_create();
    ds_map_add(headers, "Content-Type", "application/json");

    // Send the entire leaderboard to Firebase using PUT method (this will overwrite any existing leaderboard data)
    http_request(url, "PUT", headers, json_data); // Required 4 arguments: URL, method, headers, and body (as JSON string)

    ds_map_destroy(headers); // Clean up the header map

    show_message("Leaderboard saved successfully!");
}







function load_game() {
    var save_file = "save_game.ini";

    if (file_exists(save_file)) {
        ini_open(save_file);

        if (!variable_global_exists("powerUps")) {
            // Define your powerUps array structure temporarily for loading
            powerUps = [
                { name: "Jump Boost", icon: sJumpBoostIcon, effect: function() { global.jspd[0] = -10; } },
                { name: "Double Speed", icon: sDoubleSpeedIcon, effect: function() { global.moveSpd *= 2; } },
                { name: "Bounce Boost", icon: sBounceBoostIcon, effect: function() { global.bounceBack = 1.2; } },
                { name: "Dash", icon: sDashIcon, effect: function() { global.canDash = true; } },
                // Add more power-ups here
            ];
        }

        // Load player position into temporary global variables
        global.load_player_x = ini_read_real("Player", "x", 0);
        global.load_player_y = ini_read_real("Player", "y", 0);

        // Load player name
        global.player_name = ini_read_string("Player", "name", "Player");

        // Load elapsed time
        global.elapsed_time = ini_read_real("Player", "elapsed_time", 0);

        // Initialize global.powerUps if it doesn't exist
        if (!variable_global_exists("powerUps")) {
            global.powerUps = array_create(array_length(powerUps), 0);
        }
        for (var i = 0; i < array_length(powerUps); i++) {
            global.powerUps[i] = ini_read_real("PowerUps", "powerUp" + string(i), 0);
            show_debug_message("PowerUp " + string(i) + ": " + string(global.powerUps[i])); // Debug message
        }

        // Load collected orbs
        if (!variable_global_exists("collected_orbs")) {
            global.collected_orbs = ds_list_create();
        }
        for (var i = 0; ; i++) {
            if (ini_key_exists("Orbs", "orb" + string(i))) {
                ds_list_add(global.collected_orbs, ini_read_real("Orbs", "orb" + string(i), 0));
            } else {
                break; // Stop when there are no more entries
            }
        }

        ini_close();
        show_message("Game Loaded Successfully!");

        // Apply collected power-ups when loading a game
        for (var i = 0; i < array_length(powerUps); i++) {
            if (global.powerUps[i] == 1) {
                powerUps[i].effect(); // Apply the power-up effect
            }
        }

        return true; // Indicate that the game was loaded successfully
    } else {
        show_message("No save file found!");
        return false; // Indicate that the game was not loaded
    }
}


function load_leaderboard() {
    var leaderboard_file = "leaderboard.ini";

    if (file_exists(leaderboard_file)) {
        ini_open(leaderboard_file);

        // Load leaderboard
        if (!variable_global_exists("leaderboard")) {
            global.leaderboard = ds_list_create();
        }
        ds_list_clear(global.leaderboard);
        for (var i = 0; ; i++) {
            if (ini_key_exists("Leaderboard", "Entry" + string(i) + "_Name")) {
                var player_name = ini_read_string("Leaderboard", "Entry" + string(i) + "_Name", "");
                var elapsed_time = ini_read_real("Leaderboard", "Entry" + string(i) + "_Time", 0);
                ds_list_add(global.leaderboard, [player_name, elapsed_time]);
            } else {
                break; // Stop when there are no more entries
            }
        }

        ini_close();
        
    } 
}

function reset_game() {
    global.elapsed_time = 0;
    global.powerUps = [];            
    global.collected_orbs = ds_list_create(); // Create a new, empty list for collected orbs

    // Ensure power-up effects are reset
    global.jspd = [-7.15, -1.15]; // Default jump speeds
    global.moveSpd = 0.5;   // Default movement speed
    global.bounceBack = 0.4; // Default bounce-back effect
    global.canDash = false;  // Default dash ability

    // Clear old save file data
    var save_file = "save_game.ini";
    if (file_exists(save_file)) {
        file_delete(save_file);
    }
}